
******************************************************************
*
* Impact Funciton (using an artificial dataset)
*
* JOSEF BRÜDERL, LMU, March 2015
*
******************************************************************

* These are the variables in the dataset:
* id       person identifier
* time     # panel wave
* wage     monthly wage in Euro (no anticipation)
* wage1    monthly wage in Euro (with anticipation)
* marrdur  duration of marriage


*************************************
** Preliminaries    *****************
*************************************
clear 
set more off

* Load data
cd  "C:\Users\bruederl\LRZ Sync+Share\Vorlesung PDA\Stata Beispiele\Artificial Data\"    //Adapt this path!
use "Impact Function.dta", clear

***** Declare data to be panel data *****
xtset id time


******************************************
* Dummy Event Time Model - No Anticipation
******************************************
twoway  (scatter wage time, ylabel(0(1000)5000, grid angle(0))  ///
                 ymtick(500(1000)4500, grid) c(L))              ///
        (scatter wage time if marrdur==1, mcolor(red))          ///
		(scatter wage time if marrdur==2, mcolor(blue))         ///
		(scatter wage time if marrdur==3, mcolor(orange)),      ///
		legend(off)

xtreg wage i.marrdur, fe  
xtreg wage i.marrdur if id>2, fe   //same results without not-treated


******************************************
* Now with Anticipation (wage1)
******************************************
gen     anticip=0                      //anticipation dummy
replace anticip=1 if time==3 & id>2

twoway  (scatter wage1 time, ylabel(0(1000)5000, grid angle(0))  ///
                 ymtick(500(1000)4500, grid) c(L))              ///
        (scatter wage1 time if anticip==1, mcolor(yellow))          ///
		(scatter wage1 time if marrdur==1, mcolor(red))          ///
		(scatter wage1 time if marrdur==2, mcolor(blue))         ///
		(scatter wage1 time if marrdur==3, mcolor(orange)),      ///
		legend(off)

xtreg wage1         i.marrdur, fe  
xtreg wage1 anticip i.marrdur, fe  


******************************************
* How fares FD?
******************************************
gen md_1 = (time==3 & id>2)
gen md0  = marrdur==1
gen md1  = marrdur==2
gen md2  = marrdur==3

reg D.(wage md?), noconstant

reg D.(wage1 md?), noconstant

reg D.(wage1 md*), noconstant
